<?php

$treatment_categories = get_terms([
    'taxonomy' => 'zain_clinics',
    'hide_empty' => false,
    'order_by' => 'modified',
    'order' => 'DESC'
]);
?>

<?php if ($treatment_categories) : ?>
    <section id="services" class="w-100 px-0 my-5">
        <div class="container">
            <div class="row">
                <div class="py-4">
                    <h2 class="section-title mx-auto fst-italic fw-light" data-aos="fadeIn"><?= pll_e('services'); ?></h2>
                </div>
                <div class="col-12" data-aos="fadeIn" data-aos-delay="200">
                    <ul id="services-tabs-list" class="border border-gold-light nav nav-tabs justify-content-center py-3" role="tablist">
                        <?php
                        $i = 0;
                        foreach ($treatment_categories as $category) : ?>
                            <li class="nav-item d-flex" role="presentation">
                                <button class="nav-link me-4 <?= ($i == 0) ? 'active' : ''; ?>" id="service-<?= $category->slug; ?>-tab" data-bs-toggle="tab" data-bs-target="#service-<?= $category->slug; ?>" type="button" role="tab" aria-controls="service-<?= $category->slug; ?>" aria-selected="<?= ($i == 0) ? 'true' : 'false'; ?>"><?= $category->name; ?></button>
                            </li>
                        <?php $i++;
                        endforeach; ?>
                    </ul>
                    <div id="services-tabs-list-content" class="tab-content mt-4 mt-xl-5">
                        <?php
                        $j = 0;
                        foreach ($treatment_categories as $category) : ?>
                            <div class="tab-pane fade <?= ($j == 0) ? 'show active' : ''; ?>" id="service-<?= $category->slug; ?>" role="tabpanel" aria-labelledby="service-<?= $category->slug; ?>-tab">
                                <div class="row">
                                    <?php

                                    // Get posts for each treatment_category
                                    $pll_category = pll_get_term($category->term_id);

                                    $args = [
                                        'number' => 10,
                                        'orderby' => 'sort_order',
                                        'order' => 'ASC',
                                        'post_type' => 'clinic-treatments',
                                        'post_status' => 'publish',
                                        'suppress_filters' => true,
                                        'tax_query' => array(
                                            array(
                                                'taxonomy' => 'treatment_categories',
                                                'field' => 'term_id',
                                                'terms' => $pll_category
                                            )
                                        ),
                                    ];

                                    $posts = get_posts($args);

                                    if ($posts) : ?>
                                        <div class="col-12 col-lg-4 col-xl-3">
                                            <div class="card border-0 shadow">
                                                <div class="card-body">
                                                    <div class="nav flex-column nav-pills me-3" id="service-vertical-tab" role="tablist" aria-orientation="vertical">
                                                        <?php $i = 0;
                                                        foreach ($posts as $post) : ?>
                                                            <button class="nav-link <?= ($i == 0) ? 'active' : ''; ?>" id="v-<?= $post->post_name; ?>-tab" data-bs-toggle="pill" data-bs-target="#v-<?= $post->post_name; ?>" type="button" role="tab" aria-controls="v-<?= $post->post_name; ?>" aria-selected="<?= ($i == 0) ? 'true' : 'false'; ?>">
                                                                <?= $post->post_title; ?>
                                                            </button>
                                                        <?php $i++;
                                                        endforeach; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 col-lg-8 col-xl-9 pb-5">
                                            <div class="tab-content" id="service-vertical-tab-content ps-5">
                                                <?php $i = 0;
                                                foreach ($posts as $post) : setup_postdata($post); ?>
                                                    <div class="tab-pane fade <?= ($i == 0) ? 'show active' : ''; ?>" id="v-<?= $post->post_name; ?>" role="tabpanel" aria-labelledby="v-<?= $post->post_name; ?>-tab">
                                                        <?php the_post_thumbnail('', ['class' => 'img-fluid mb-4']); ?>
                                                        <h3 class="mb-3"><?php the_title(); ?></h3>
                                                        <?php the_content(); ?>
                                                    </div>
                                                <?php $i++;
                                                endforeach; ?>
                                            </div>
                                        </div>
                                    <?php else : ?>
                                        <div class="col-12 text-center">
                                            No results
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php $j++;
                        endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php if ($treatment_categories) : ?>
    <section id="services" class="w-100 px-0 my-5">
        <div class="container-fluid px-xl-5">
            <div class="row">
                <div class="py-4">
                    <h2 class="section-title mx-auto fst-italic fw-light" data-aos="fadeIn"><?= pll_e('services'); ?></h2>
                </div>
                <div class="col-12" data-aos="fadeIn" data-aos-delay="200">
                    <ul id="services-tabs-list" class="border border-gold-light nav nav-tabs justify-content-center py-3" role="tablist">
                        <?php
                        $i = 0;
                        foreach ($treatment_categories as $category) : ?>
                            <li class="nav-item d-flex" role="presentation">
                                <span class="icon">
                                    <img src="<?= get_field('image_icon', $category->taxonomy . '_' . $category->term_id); ?>">
                                </span>

                                <button class="nav-link me-4 <?= ($i == 0) ? 'active' : ''; ?>" id="service-<?= $category->slug; ?>-tab" data-bs-toggle="tab" data-bs-target="#service-<?= $category->slug; ?>" type="button" role="tab" aria-controls="service-<?= $category->slug; ?>" aria-selected="<?= ($i == 0) ? 'true' : 'false'; ?>"><?= $category->name; ?></button>
                            </li>
                        <?php $i++;
                        endforeach; ?>
                    </ul>
                    <div id="services-tabs-list-content" class="tab-content mt-4 mt-xl-5">
                        <?php
                        $j = 0;
                        foreach ($treatment_categories as $category) : ?>
                            <div class="tab-pane fade <?= ($j == 0) ? 'show active' : ''; ?>" id="service-<?= $category->slug; ?>" role="tabpanel" aria-labelledby="service-<?= $category->slug; ?>-tab">
                                <div class="row">
                                    <?php

                                    // Get posts for each treatment_category
                                    $pll_category = pll_get_term($category->term_id);

                                    $args = [
                                        'number' => 10,
                                        'orderby' => 'sort_order',
                                        'order' => 'ASC',
                                        'post_type' => 'treatments',
                                        'post_status' => 'publish',
                                        'suppress_filters' => true,
                                        'tax_query' => array(
                                            array(
                                                'taxonomy' => 'treatment_categories',
                                                'field' => 'term_id',
                                                'terms' => $pll_category
                                            )
                                        ),
                                    ];

                                    $posts = get_posts($args);

                                    if ($posts) : ?>
                                        <div class="col-12 col-lg-4 col-xl-3">
                                            <div class="card border-0 shadow">
                                                <div class="card-body">
                                                    <div class="nav flex-column nav-pills me-3" id="service-vertical-tab" role="tablist" aria-orientation="vertical">
                                                        <?php $i = 0;
                                                        foreach ($posts as $post) : ?>
                                                            <button class="nav-link <?= ($i == 0) ? 'active' : ''; ?>" id="v-<?= $post->post_name; ?>-tab" data-bs-toggle="pill" data-bs-target="#v-<?= $post->post_name; ?>" type="button" role="tab" aria-controls="v-<?= $post->post_name; ?>" aria-selected="<?= ($i == 0) ? 'true' : 'false'; ?>">
                                                                <?= $post->post_title; ?>
                                                            </button>
                                                        <?php $i++;
                                                        endforeach; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 col-lg-8 col-xl-9 pb-5">
                                            <div class="tab-content" id="service-vertical-tab-content ps-5">
                                                <?php $i = 0;
                                                foreach ($posts as $post) : setup_postdata($post); ?>
                                                    <div class="tab-pane fade <?= ($i == 0) ? 'show active' : ''; ?>" id="v-<?= $post->post_name; ?>" role="tabpanel" aria-labelledby="v-<?= $post->post_name; ?>-tab">
                                                        <?php the_post_thumbnail('', ['class' => 'img-fluid mb-4']); ?>
                                                        <h3 class="mb-3"><?php the_title(); ?></h3>
                                                        <?php the_content(); ?>
                                                    </div>
                                                <?php $i++;
                                                endforeach; ?>
                                            </div>
                                        </div>
                                    <?php else : ?>
                                        <div class="col-12 text-center">
                                            No results
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php $j++;
                        endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php if ($treatment_categories) : ?>
    <section id="services" class="w-100 px-0 my-5">
        <div class="container-fluid px-xl-5">
            <div class="row">
                <div class="py-4">
                    <h2 class="section-title mx-auto fst-italic fw-light" data-aos="fadeIn"><?= pll_e('services'); ?></h2>
                </div>
                <div class="col-12" data-aos="fadeIn" data-aos-delay="200">
                    <div class="row">
                        <div class="col-12 col-lg-4 col-xl-3">
                            <div class="card border-0 shadow">
                                <div class="card-body">
                                    <div class="nav flex-column nav-pills me-3" id="service-vertical-tab" role="tablist" aria-orientation="vertical">
                                        <?php $i = 0;
                                        foreach ($treatment_categories as $category) : ?>
                                        <div class="d-flex mb-3">
                                            <span class="icon">
                                                <img src="<?= get_field('image_icon', $category->taxonomy . '_' . $category->term_id); ?>">
                                            </span>
                                            <button class="nav-link pb-0 my-auto <?= ($i == 0) ? 'active' : ''; ?>" id="v-<?= $category->slug; ?>-tab" data-bs-toggle="pill" data-bs-target="#v-<?= $category->slug; ?>" type="button" role="tab" aria-controls="v-<?= $category->slug; ?>" aria-selected="<?= ($i == 0) ? 'true' : 'false'; ?>">
                                                <?= $category->name; ?>
                                            </button>
                                        </div>
                                        <?php $i++;
                                        endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-lg-8 col-xl-9 pb-5">
                            <div class="tab-content" id="service-vertical-tab-content ps-5">
                                <?php $i = 0;
                                foreach ($treatment_categories as $category) : ?>
                                    <div class="tab-pane fade <?= ($i == 0) ? 'show active' : ''; ?>" id="v-<?= $category->slug; ?>" role="tabpanel" aria-labelledby="v-<?= $category->slug; ?>-tab">
                                        <h3 class="mb-3"><?= $category->name; ?></h3>
                                        <?= $category->description; ?>
                                    </div>
                                <?php $i++;
                                endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>